<?php
/**
 * The template for displaying content single room.
 *
 * This template can be overridden by copying it to yourtheme/wp-hotel-booking/content-single-room.php.
 *
 * @author  ThimPress, leehld
 * @package WP-Hotel-Booking/Templates
 * @version 1.6
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit();

global $hb_settings;
$price_display = apply_filters( 'hotel_booking_loop_room_price_display_style', $hb_settings->get( 'price_display' ) );
$prices        = hb_room_get_selected_plan( get_the_ID() );
$prices        = isset( $prices->prices ) ? $prices->prices : array();
?>

<?php
/**
 * hotel_booking_before_single_product hook
 */
do_action( 'hotel_booking_before_single_product' );

if ( post_password_required() ) {
	echo get_the_password_form();

	return;
} ?>

<div id="room-<?php the_ID(); ?>" <?php post_class( 'hb_single_room' ); ?>>

	<?php
	/**
	 * hotel_booking_before_loop_room_summary hook
	 */
	do_action( 'hotel_booking_before_single_room' );
	?>

	<div class="summary entry-summary">

		<?php
		/**
		 * hotel_booking_single_room_title hook
		 */
		do_action( 'hotel_booking_single_room_title' );

		?>

		<div class="footer-content-room price-single">
			<?php if ( $prices ) {
				$min_price = is_numeric( min( $prices ) ) ? min( $prices ) : 0;
				$max_price = is_numeric( max( $prices ) ) ? max( $prices ) : 0;
				$min       = $min_price + ( hb_price_including_tax() ? ( $min_price * hb_get_tax_settings() ) : 0 );
				$max       = $max_price + ( hb_price_including_tax() ? ( $max_price * hb_get_tax_settings() ) : 0 );
				?>
				<?php if ( get_theme_mod( 'thim_hb_single_show_book_email' ) == true ) { ?>
					<div class="thim-button-register-room">
						<a class="thim-enroll-room-button hb_button hb_primary" href="#"><?php esc_html_e( 'Register', 'sailing' ); ?></a>
					</div>
				<?php } ?>

				<div class="price">

					<span class="title-price"><?php _e( 'Price:', 'sailing' ); ?></span>

					<?php if ( $price_display === 'max' ) { ?>
						<span class="price_value price_max"><?php echo hb_format_price( $max ) ?>
							<span class="unit"><?php _e( 'night', 'sailing' ); ?></span></span>
					<?php } elseif ( $price_display === 'min_to_max' && $min !== $max ) { ?>
						<span class="price_value price_min_to_max"><?php echo hb_format_price( $min ) ?> - <?php echo hb_format_price( $max ) ?>
							<span class="unit"><?php _e( 'night', 'sailing' ); ?></span></span>
					<?php } else { ?>
						<span class="price_value price_min"><?php echo hb_format_price( $min ) ?>
							<span class="unit"><?php _e( 'night', 'sailing' ); ?></span></span>
					<?php } ?>

				</div>

			<?php } ?>

		</div>

		<?php
		/**
		 * hotel_booking_single_room_gallery hook
		 */
		do_action( 'hotel_booking_single_room_gallery' );

		/**
		 * hotel_booking_single_room_infomation hook
		 */
		do_action( 'hotel_booking_single_room_infomation' );
		?>

	</div>

	<?php
	/**
	 * hotel_booking_after_single_room hook
	 */
	do_action( 'hotel_booking_after_single_room' );
	?>

	<div id="contact-form-registration">
		<?php
		$short_code = get_theme_mod( 'thim_hb_single_shortcode_book_email' );
		if ( !empty( $short_code ) ) {
			echo do_shortcode( '[contact-form-7 id="' . $short_code . '" title="Book Online"]' );
		}
		?>
	</div>

</div>

<?php
/**
 * hotel_booking_after_single_product hook
 */
do_action( 'hotel_booking_after_single_product' ); ?>
