<?php
/**
 * thim functions and definitions
 *
 * @package thim
 */
/**
 * Set the content width based on the theme's design and stylesheet.
 */
define( 'TP_THEME_DIR', trailingslashit( get_template_directory() ) );
define( 'TP_THEME_URI', trailingslashit( get_template_directory_uri() ) );
define( 'TP_THEME_VERSION', '4.1.7' );

if ( ! isset( $content_width ) ) {
	$content_width = 640; /* pixels */
}

if ( ! function_exists( 'thim_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function thim_setup() {

		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on thim, use a find and replace
		 * to change 'sailing' to the name of your theme in all the template files
		 */
		load_theme_textdomain( 'sailing', get_stylesheet_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );
		add_theme_support( 'woocommerce' );
		add_theme_support( 'thim-core' );
		add_theme_support( 'sailing-demo-data' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link http://codex.wordpress.org/Function_Reference/add_theme_support#Post_Thumbnails
		 */
		add_theme_support( 'post-thumbnails' );
		// This theme uses wp_nav_menu() in one location.
		register_nav_menus( array(
			'primary' => esc_html__( 'Primary Menu', 'sailing' ),
		) );

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

		/*
		 * Enable support for Post Formats.
		 * See http://codex.wordpress.org/Post_Formats
		 */
		add_theme_support( 'post-formats', array(
			'aside',
			'image',
			'video',
			'quote',
			'link',
			'gallery',
			'audio'
		) );

		add_theme_support( "title-tag" );
		// Set up the WordPress core custom background feature.
		add_theme_support( 'custom-background', apply_filters( 'thim_custom_background_args', array(
			'default-color' => 'ffffff',
			'default-image' => '',
		) ) );

		// Support Gutenberg
		add_theme_support( 'wp-block-styles' );

		add_theme_support( 'editor-styles' );

		add_editor_style( 'style-editor.css' );

		add_theme_support( 'align-wide' );

		add_theme_support( 'responsive-embeds' );

		add_theme_support( 'editor-color-palette', array(
			array(
				'name'  => esc_html__( 'Primary Color', 'sailing' ),
				'slug'  => 'primary',
				'color' => get_theme_mod( 'thim_body_primary_color', '#2eb0d1' ),
			),
			array(
				'name'  => esc_html__( 'Title Color', 'sailing' ),
				'slug'  => 'title',
				'color' => get_theme_mod( 'thim_font_title_color', '#2a2a2a' ),
			),
			array(
				'name'  => esc_html__( 'Sub Title Color', 'sailing' ),
				'slug'  => 'sub-title',
				'color' => '#666666',
			),
			array(
				'name'  => esc_html__( 'Border Color', 'sailing' ),
				'slug'  => 'border-input',
				'color' => '#dddddd',
			),
		) );

		// Add custom editor font sizes.
		add_theme_support(
			'editor-font-sizes',
			array(
				array(
					'name'      => __( 'Small', 'sailing' ),
					'shortName' => __( 'S', 'sailing' ),
					'size'      => 13,
					'slug'      => 'small',
				),
				array(
					'name'      => __( 'Normal', 'sailing' ),
					'shortName' => __( 'M', 'sailing' ),
					'size'      => 15,
					'slug'      => 'normal',
				),
				array(
					'name'      => __( 'Large', 'sailing' ),
					'shortName' => __( 'L', 'sailing' ),
					'size'      => 28,
					'slug'      => 'large',
				),
				array(
					'name'      => __( 'Huge', 'sailing' ),
					'shortName' => __( 'XL', 'sailing' ),
					'size'      => 36,
					'slug'      => 'huge',
				),
			)
		);
	}

endif;
add_action( 'after_setup_theme', 'thim_setup' );

/**
 * Register widget area.
 *
 * @link http://codex.wordpress.org/Function_Reference/register_sidebar
 */

function thim_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar', 'sailing' ),
		'id'            => 'sidebar-1',
		'description'   => '',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title"><span>',
		'after_title'   => '</span></h3>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Toolbar', 'sailing' ),
		'id'            => 'toolbar',
		'description'   => '',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
	if ( get_theme_mod( 'thim_header_style' ) == 'header_v2' ) {
		register_sidebar( array(
			'name'          => esc_html__( 'Logo Left', 'sailing' ),
			'id'            => 'logo_left',
			'description'   => 'Display widgets in left of logo, using with header layout 02',
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		) );

		register_sidebar( array(
			'name'          => esc_html__( 'Logo Right', 'sailing' ),
			'id'            => 'logo_right',
			'description'   => 'Display widgets in right of logo, using with header layout 02',
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		) );
	} elseif ( get_theme_mod( 'thim_header_style' ) == 'header_v3' ) {
		register_sidebar( array(
			'name'          => 'Menu Left',
			'id'            => 'menu_left',
			'description'   => esc_html__( 'Menu Left', 'sailing' ),
			'before_widget' => '<li id="%1$s" class="widget %2$s">',
			'after_widget'  => '</li>',
			'before_title'  => '<h3>',
			'after_title'   => '</h3>',
		) );
		register_sidebar( array(
			'name'          => 'Menu Right',
			'id'            => 'menu_right',
			'description'   => esc_html__( 'Menu Right', 'sailing' ),
			'before_widget' => '<li id="%1$s" class="widget %2$s">',
			'after_widget'  => '</li>',
			'before_title'  => '<h3>',
			'after_title'   => '</h3>',
		) );
	} else {
		register_sidebar( array(
			'name'          => 'Menu Right',
			'id'            => 'menu_right',
			'description'   => esc_html__( 'Menu Right', 'sailing' ),
			'before_widget' => '<li id="%1$s" class="widget %2$s">',
			'after_widget'  => '</li>',
			'before_title'  => '<h3>',
			'after_title'   => '</h3>',
		) );
	}

	if ( class_exists( 'WP_Hotel_Booking' ) || class_exists( 'TP_Hotel_Booking' ) ) {
		register_sidebar( array(
			'name'          => esc_html__( 'Rooms Sidebar', 'sailing' ),
			'id'            => 'sidebar_hotel',
			'description'   => esc_html__( 'Sidebar Of Rooms', 'sailing' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		) );
	}

	register_sidebar( array(
		'name'          => esc_html__( 'Offcanvas Sidebar', 'sailing' ),
		'id'            => 'offcanvas_sidebar',
		'description'   => 'Offcanvas Sidebar',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'Main Bottom', 'sailing' ),
		'id'            => 'main-bottom',
		'description'   => '',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'Footer', 'sailing' ),
		'id'            => 'footer',
		'description'   => '',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'Footer Copyright', 'sailing' ),
		'id'            => 'footer_copyright',
		'description'   => '',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
}

add_action( 'widgets_init', 'thim_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function thim_scripts() {

	wp_enqueue_style( 'thim-style', get_stylesheet_uri(), array(), TP_THEME_VERSION );

	wp_enqueue_style( 'sailing-slick', TP_THEME_URI . 'assets/css/slick.css', array() );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
	wp_register_script( 'waypoints', TP_THEME_URI . 'assets/js/libs/waypoints.min.js', array( 'jquery' ), TP_THEME_VERSION, true );
	wp_register_script( 'theia-sticky-sidebar', TP_THEME_URI . 'assets/js/libs/theia-sticky-sidebar.js', array( 'jquery' ), TP_THEME_VERSION, true );
	//wp_enqueue_script( 'smooth-scoll', TP_THEME_URI . 'assets/js/libs/smooth-scoll.min.js', array( 'jquery' ), TP_THEME_VERSION, true );
	//wp_enqueue_script( 'slick', TP_THEME_URI . 'assets/js/libs/slick.min.js', array( 'jquery' ), TP_THEME_VERSION, true );
	wp_enqueue_script( 'select2', TP_THEME_URI . 'assets/js/libs/select2.min.js', array( 'jquery' ), TP_THEME_VERSION, true );
	//wp_enqueue_script( 'pikaday', TP_THEME_URI . 'assets/js/libs/pikaday.min.js', array( 'jquery' ), TP_THEME_VERSION, true );
	//wp_enqueue_script( 'parallax', TP_THEME_URI . 'assets/js/libs/parallax.min.js', array( 'jquery' ), TP_THEME_VERSION, true );
	//wp_enqueue_script( 'navigation', TP_THEME_URI . 'assets/js/libs/navigation.min.js', array( 'jquery' ), TP_THEME_VERSION, true );
	//wp_register_script( 'moment', TP_THEME_URI . 'assets/js/libs/moment.min.js', array( 'jquery' ), TP_THEME_VERSION, true );
	wp_enqueue_script( 'modernizr', TP_THEME_URI . 'assets/js/libs/modernizr.min.js', array( 'jquery' ), TP_THEME_VERSION, true );
	wp_register_script( 'magnific-popup', TP_THEME_URI . 'assets/js/libs/magnific-popup.min.js', array( 'jquery' ), TP_THEME_VERSION, true );
	wp_register_script( 'isotope', TP_THEME_URI . 'assets/js/libs/isotope.min.js', array( 'jquery' ), TP_THEME_VERSION, true );
	wp_enqueue_script( 'greensock', TP_THEME_URI . 'assets/js/libs/greensock.min.js', array( 'jquery' ), TP_THEME_VERSION, true );
	wp_register_script( 'fancybox', TP_THEME_URI . 'assets/js/libs/fancybox.min.js', array( 'jquery' ), TP_THEME_VERSION, true );
	wp_register_script( 'owl-carousel', TP_THEME_URI . 'assets/js/libs/carousel.min.js', array( 'jquery' ), TP_THEME_VERSION, true );
	wp_register_script( 'cookie', TP_THEME_URI . 'assets/js/libs/cookie.min.js', array( 'jquery' ), TP_THEME_VERSION, true );
	wp_register_script( 'flexslider', TP_THEME_URI . 'assets/js/libs/flexslider-min.js', array( 'jquery' ), TP_THEME_VERSION, true );
	wp_enqueue_script( 'thim-main', TP_THEME_URI . 'assets/js/main.min.js', array('imagesloaded'), TP_THEME_VERSION, true );

	wp_enqueue_script( 'prettyPhoto' );
	wp_enqueue_script( 'prettyPhoto-init' );
	wp_enqueue_style( 'woocommerce_prettyPhoto_css' );

	wp_dequeue_script( 'sb-font-awesome' );
	/**
	 * Load css rtl.
	 */
	if ( is_rtl() || get_theme_mod( 'thim_rtl_support' ) == true ) {
		wp_enqueue_style( 'thim-css-rtl', TP_THEME_URI . 'rtl.css', array() );
	}
}

add_action( 'wp_enqueue_scripts', 'thim_scripts' );

function thim_custom_admin_scripts() {
	wp_enqueue_script( 'thim-admin-custom-script', TP_THEME_URI . 'assets/js/admin-custom-script.js', array( 'jquery' ), TP_THEME_VERSION, true );
	wp_enqueue_style( 'thim-custom-admin', TP_THEME_URI . 'assets/css/custom-admin.css', array() );
}

add_action( 'admin_enqueue_scripts', 'thim_custom_admin_scripts' );

/**
 * Add installer.
 */
require TP_THEME_DIR . 'inc/admin/installer/installer.php';
/**
 * Library.
 */
require TP_THEME_DIR . 'inc/libs/Tax-meta-class/Tax-meta-class.php';
require TP_THEME_DIR . 'inc/tax-meta.php';
require TP_THEME_DIR . 'inc/libs/theme-wrapper.php';
/**
 * Required plugin.
 */
if ( is_admin() && current_user_can( 'manage_options' ) ) {
	require TP_THEME_DIR . 'inc/data/plugins-require.php';
}
/**
 * Custom function.
 */
require TP_THEME_DIR . 'inc/custom-functions.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 */

require get_template_directory() . '/inc/extras.php';
//require TP_THEME_DIR . 'inc/aq_resizer.php';
require TP_THEME_DIR . 'inc/libs/down_image_size.php';

/**
 * Customizer additions.
 */
require TP_THEME_DIR . 'inc/header/logo.php';
include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
/**
 * Function Thim Core.
 */
if ( thim_plugin_active( 'thim-core' ) ) {
	require TP_THEME_DIR . 'inc/widgets/widgets.php';
	require TP_THEME_DIR . 'inc/customizer.php';
	require TP_THEME_DIR . 'inc/thim-core-function.php';
}
/**
 * Woocommerce.
 */
if ( class_exists( 'WooCommerce' ) ) {
	require get_template_directory() . '/woocommerce/woocommerce.php';
}

if ( thim_plugin_active( 'elementor' ) ) {
	require_once TP_THEME_DIR . 'elementor-addons/elementor-addons.php';
}

/**
 * Update new version.
 */
require TP_THEME_DIR . 'inc/upgrade.php';